
#include "g_local.h"
#include "g_hitmen.h"

void hm_ChangeWeapon( void );
void hm_ChangeClientWeapon( edict_t *ent, int oldweap, int newweap );
void hm_incrementammo(gclient_t* client);
void hm_incrementhealth(edict_t *ent, gclient_t* client);
//void Hm_LoadMOTD( void );
void LoadHitmenWorldIni( void );
void VerifyIniFileValues( void );
void VerifyLevelIniValues( void );
void hm_ProcessWeaponsList( void );
//void CheckForCheating( edict_t *ent );

static void Hm_set_ammo(gclient_t* cl, int count, int nWeap, qboolean ClearClip);
static void hm_next_weapon ( void );
static char *IntToChar(int Number);

extern void AutoLoadWeapon( gclient_t *client, gitem_t *weapon, gitem_t *ammo );
extern int QweryClipIndex (gitem_t *item);
//extern void KickCheater( char *twat );

//#define MAXHMWEAPONS	7	// Moved into G_locals.h
#define HMLISTITEMS		(MAXHMWEAPONS+2)

#define HM_ONESECOND	1.0

//#define MOTD_lines		3

#define	CHAN_HLTH						 5 // seems to work fine (can go up to 7 for sound channels?)

#define hm_PISTOL_ROUNDS			15
#define hm_TOMMYGUN_ROUNDS			50
#define hm_SHOTGUN_ROUNDS			16
#define hm_BARMACHINEGUN_ROUNDS 	30
#define hm_GRENADELAUNCHER_ROUNDS	3
#define hm_ROCKETLAUNCHER_ROUNDS	10
#define	hm_FLAMEGUN_ROUNDS			80

#define hm_PISTOL					1
#define hm_SHOTGUN					2
#define hm_TOMMYGUN					4
#define hm_BARMACHINEGUN		 	8
#define hm_GRENADELAUNCHER			16
#define hm_ROCKETLAUNCHER			32
#define	hm_FLAMEGUN					64

typedef struct Hitmenitem_s
{
	char		*szName;                    // weapon name                    
    char		*szAmmo;                    // weapon ammo                    

    int         nAmmoInitial;               // amount of ammo on switch       
    int         nAmmoIncrement;             // amount of ammo given per second   
    int         nAmmoSecs;                  // secs to wait before adding ammo
    int         nAmmoMax;                   // max amount of ammo             

    int         nHmIndexWeapon;				// itemlist index for weapon (set in HitmenInit)
    int         nHmIndexAmmo;				// itemlist index for ammo (set in HitmenInit)

//    char*       szMessage;                  // switch message
} Hitmenitem_t;

/////////////////////////////////////////////////////////////////////////////

// Changed to differnet types see ini file load function.
//cvar_t	*HmRandomWeapon;
//cvar_t	*HmWeaponTime;
//cvar_t	*HmSoundWarn;

/////////////////////////////////////////////////////////////////////////////
// Note that the current weapon index (1-10) always corresponds to the 
// standard weapons in order (blaster through bfg10k). This is still the case 
// even if the user bans certain weapons (e.g. the bfg) and/or specifies a 
// specific order in which case the NIQ-determined current weapon is converted
// to the standard weapon index 1-10.

Hitmenitem_t Hitmenlist[HMLISTITEMS] = 
{
	{
		NULL
	},	// leave index 0 alone

	{//1
		"spistol",					// doesn't use any ammo!
        "bullets",                
        hm_PISTOL_ROUNDS,			// Initial ammo on weapon change
        2,							// Amount per seconds to give
        1,							// How many seconds before adding ammo
        200,						// Maximum amount of ammo full stop
        999,                     
        999
//        "switching to super magnum"        
	},

	{//2
		"shotgun",              
        "shells",               
        hm_SHOTGUN_ROUNDS,
        1,
        1,
        100,
        999,
        999
//      "switching to shotgun"        
	},

	{//3
		"tommygun",           
        "bullets",              
        hm_TOMMYGUN_ROUNDS,                     
        5,                     
        1,
        200,
        999,                     
        999
//        "switching to tommygun"        
	},

	{//4
		"Heavy machinegun",             
        "308cal",              
        hm_BARMACHINEGUN_ROUNDS,                     
        5,
        2,                     
        90,                    
        999,                     
        999
//        "switching to HMG"        
	},

	{//5
		"Grenade Launcher",     
        "grenades",             
        hm_GRENADELAUNCHER_ROUNDS,                     
        1,                     
        2,
        12,
        999,                     
        999
//        "switching to grenade launcher"        
	},

	{//6
		"Bazooka",      
        "rockets",              
        hm_ROCKETLAUNCHER_ROUNDS,                     
        2,                     
        2,
        25,                    
        999,                     
        999
//        "switching to bazooka"        
	},

	{//7
		"FlameThrower",         
        "Gas",                
        hm_FLAMEGUN_ROUNDS,                     
        10,                     
        1,
        200,                    
        999,                     
        999
 //       "switching to flamethrower"        
	},

	// end of list marker
	{NULL}
};

//*************************************************************************

// Variables and defines go here.
#define	INI_FILE	"hitmen.ini"

int			HmRandomWeapon		= true; 	// Are the weapons changed randomly
int			HmSoundWarn			= true; 	// Do we want audible sound before weapon switch
int			HmHealthSound		= false;		// Do we want health inc sound 
int			HmKillForHealth		= false;	// Do we to kill to replenish our health
//int			HmShowHealth		= true;		// Show attackers health when we are dead.
int			HmHookAvailable		= false;		// Is the hook available to use?
//int			HmStdlogging		= false;	// Is the hook available to use?
int			HmPistol1Shot		= true;		// Can the pistol kill in 1 shot
int			HmShowGunTimer		= true;		// Show the time to change timer
//int			HmBanAnnonymous		= true;		// Ban annonymous text
//int			HmKillTeamMates		= false;	// Can you kill your team mates

int			HmWeaponTime		= 50;		// Number of seconds before weapon changes
int			HmWeaponsAvail		= 127;		// What weapons are available in the game
//int			HmMOTDTime			= 4;		// How long to display the MOTD for
//int			HmStatTime			= 8;		// How long to display the Stats and Config for
//int			Hmfraglimit			= 30;
//int			Hmtimelimit			= 15;


//wolf added for special BC debugging...logging of PugLords using patch dll's
int			HmWhoIsYourDaddy 	= false;		// Special Debugging mode that will never be seen

// 1 - Pistol  2 - Shotgun  4 - Tommy gun  8 - HMG
// 16 - Grenade launcher  32 - Bazooka  64 - Flamethrower

// 1+2+4+8+16+32+64 = 127 Subtract whichever to remove

//
// Hitmen Ini file options
//
typedef struct
{
	char	*ident;
	int		*variable;
	int		MinVariable;
	int		MaxVariable;
	int		DefaultVariable;
} INI_OPTION;

INI_OPTION	option[] = 

//	Noraml Hitmen Options

	{	{"randweap",		&HmRandomWeapon,	0,1,1},
		{"soundwarn",		&HmSoundWarn,		0,1,1},
		{"healthsnd",		&HmHealthSound,		0,1,0},
		{"killforhealth",	&HmKillForHealth,	0,1,0},
//		{"showhealth",		&HmShowHealth,		0,1,1},
		{"hookavail",		&HmHookAvailable,	0,1,0},
//		{"stdlog",			&HmStdlogging,		0,1,1},
		{"oneshot",			&HmPistol1Shot,		0,1,1},
		{"guntimer",		&HmShowGunTimer,	0,1,1},
//		{"bananontext",		&HmBanAnnonymous,	0,1,1},
		{"whoisyourdaddy",	&HmWhoIsYourDaddy,	0,1,0},
//		{"killteammates",   &HmKillTeamMates,   0,1,0},

		{"weapontime",		&HmWeaponTime,		30,300,60},
		{"weapons",			&HmWeaponsAvail,	1,127,127}
//		{"motdtime",		&HmMOTDTime,		1,8,4},
//		{"stattime",		&HmStatTime,		4,20,6},
//		{"fraglimit",		&Hmfraglimit,		0,999,30},
//		{"timelimit",		&Hmtimelimit,		0,999,15}
	};

#define MAX_OPTIONS (sizeof(option)/sizeof(option[0]))

//char	charnumber[20];

//*************************************************************************

/*typedef struct   // Message of the Day
	{
	char textline[100];
	} MOTD_t;

	MOTD_t	MOTD[20];
*/
//*************************************************************************

void hm_CheckWeaponTimer( void )
	{
	int		i;
	edict_t	*ent;
	float	fTimeLeft;
	static qboolean bDidIntermission = false;
	static qboolean bReset_Timer = false;

	// If only 1 weapon don't bother doing anything.
	if (game.Num_Weapons == 1)
		return;


	// If we are swapping levels then stop doing any weapon timer stuff

	if ((level.modeset == FREEFORALL) || (level.modeset == MATCHSETUP)) //FREDZ fix
//	if (level.intermissiontime)
    {
        if(!bDidIntermission)
			{
            // yes -- change it (no need to reset timer)
		//	hm_ChangeWeapon();

			bDidIntermission = true;
			bReset_Timer = true;
			return;
    		}
		return;
		}

    bDidIntermission = false;

	//
	// If we are in the game, but we've just started a new level then we need to
	// reset the weapon timer.
	if ((bReset_Timer) && (level.modeset = STARTINGPUB) || (level.modeset == STARTINGMATCH)) //FREDZ fix	
//	if ((level.intermissiontime <= 0) && (bReset_Timer))
		{
		game.Weapon_Timer = level.time + game.Weapon_Timer_Reset;
		bReset_Timer = false;
		}

	if ( game.Weapon_Timer <= level.time )
		{
		game.Weapon_Timer = level.time + game.Weapon_Timer_Reset;
		hm_ChangeWeapon();
		}
	else if(HmSoundWarn)
        {
        fTimeLeft = game.Weapon_Timer - level.time;

		if ( fTimeLeft == 1.0 || fTimeLeft == 2.0 || fTimeLeft == 3.0 )
            {
        	// warning sound before switching weapon

            // warn all clients that the weapon is about to change even if they are dead
    	    for (i=1; i<=maxclients->value; i++)
                {
	    	    ent = g_edicts + i;
            	if (!ent->inuse)
	            	continue;

            	if (!ent->client)
	            	continue;

    			gi.sound(ent, CHAN_ITEM, gi.soundindex("world/switches/thunk switch.wav"), 1, ATTN_NORM, 0);
                }
            }
        }

	}

//***************************************************************************
//
//	Store the previous weapon so we know what to remove before giving the
//	player the next one. Then call the routine to do the swap.
//

void hm_ChangeWeapon( void )
	{
   	edict_t	*ent;
    int		i;
	int		HmOldweapon;

	HmOldweapon = game.Current_Weapon;

	hm_next_weapon();

	// get all current clients to change to new weapon
	for (i=1; i<=maxclients->value; i++)
        {
		ent = g_edicts + i;

    	if (!ent->inuse)
	    	continue;

		if ((teamplay->value) && (ent->client->pers.team == 0))
			continue;

		hm_ChangeClientWeapon( ent, HmOldweapon, game.Current_Weapon );
    	}
	}

//***************************************************************************
//
//	This will do the actually swapping of the weapon by removing the current
//	one and allocating the next one.
//

void hm_ChangeClientWeapon( edict_t *ent, int HmOldweapon, int HmNewweapon )
	{
	gclient_t	*client;
	gitem_t		*item, *ammo;
	int			nNewAmmoAmount;

	client = ent->client;
	if (!client)
		return;

    // is he dead?
	if (ent->health < 1)
       return;

	//FREDZ fix
	if (ent->client->pers.spectator == SPECTATING && !ent->client->pers.team)
		return;

	if ((level.modeset == FINALCOUNT) || (level.modeset == ENDMATCHVOTING)) //FREDZ fix
		return;

	// Remove the old weapon.
    client->pers.inventory[Hitmenlist[HmOldweapon].nHmIndexWeapon] = 0;

	// Remove old ammo.
    //if((nOldAmmoIndex != 999) && (nOldAmmoIndex != nNewAmmoIndex))
//		Hm_set_ammo (ent->client, 0, HmOldweapon);
	
	// Add the new weapon to the inventory.
	client->pers.inventory[Hitmenlist[HmNewweapon].nHmIndexWeapon] = 1;

	// Make the new weapon the current one.
	client->pers.selected_item = Hitmenlist[HmNewweapon].nHmIndexWeapon;
	client->newweapon = &itemlist[Hitmenlist[HmNewweapon].nHmIndexWeapon];

    // allocate new ammo:
	nNewAmmoAmount = Hitmenlist[HmNewweapon].nAmmoInitial;
   	Hm_set_ammo(ent->client, nNewAmmoAmount, HmNewweapon, true);

	// Set the index for this ammo type.
	ent->client->ammo_index = Hitmenlist[HmNewweapon].nHmIndexAmmo;

	// Load the weapon with the correct ammo.
	item = FindItem(Hitmenlist[HmNewweapon].szName);
	ammo = FindItem (item->ammo);
	AutoLoadWeapon( client, item, ammo );

	ChangeWeapon(ent);

	gi.sound (ent, CHAN_AUTO, gi.soundindex ("misc/w_pkup.wav"), 1, ATTN_NORM, 0);
	}

/////////////////////////////////////////////////////////////////////////////
// Hm_set_ammo:
//
static void Hm_set_ammo(gclient_t* cl, int count, int nWeap, qboolean ClearClip)
	{
	gitem_t		*weapon;
	int			clip_index;

	if (!cl) 
		return; 

	// long-time bug fix?: if count is 0, we are clearing the ammo which we always have to do
    // if user has cheated, don't reset ammo until back down to normal levels
//	if ((count != 0) && (cl->pers.inventory[Hitmenlist[nWeap].nListIndexAmmo] > Hitmenlist[nWeap].nAmmoMax))
//        return;

	if (count > Hitmenlist[nWeap].nAmmoMax)
		count = Hitmenlist[nWeap].nAmmoMax;

	// If the clearclip flag is set then we want to make sure the ammo added doesn't
	// include whats in the clip from the last time we had this weapon.
	if (ClearClip)
		{
		weapon = FindItem(Hitmenlist[nWeap].szName);
		clip_index = QweryClipIndex( weapon );
		cl->pers.weapon_clip[clip_index] = 0;
		}

    cl->pers.inventory[Hitmenlist[nWeap].nHmIndexAmmo] = count;

	}

/////////////////////////////////////////////////////////////////////////////
// Hm_add_ammo:
//
static void Hm_add_ammo(gclient_t* cl, int count, int nWeap)
	{
	if (!cl) 
		return; 

	// long-time bug fix?: if count is 0, we are clearing the ammo which we always have to do
    // if user has cheated, don't reset ammo until back down to normal levels
//	if ((count != 0) && (cl->pers.inventory[Hitmenlist[nWeap].nListIndexAmmo] > Hitmenlist[nWeap].nAmmoMax))
//        return;

	count += cl->pers.inventory[Hitmenlist[nWeap].nHmIndexAmmo];

	if (count > Hitmenlist[nWeap].nAmmoMax)
		count = Hitmenlist[nWeap].nAmmoMax;

    cl->pers.inventory[Hitmenlist[nWeap].nHmIndexAmmo] = count;

	}

/////////////////////////////////////////////////////////////////////////////
// Hm_next_weapon
//

void hm_next_weapon ( void )
	{
	int			i, NewWeapIdx;
	qboolean	AnyUnused=false;

	if (game.Num_Weapons == 1)
		{
		game.Current_Weapon = game.HmWeaponsAvailList[0].nWeaponNumber;
		return;
		}

	// Get the next weapon in a random order.
	if (HmRandomWeapon)
		{
		for ( i=0; i < game.Num_Weapons; i++ )
			if ( game.HmWeaponsAvailList[i].nAlreadyUsed == false )
				AnyUnused = true;

		if(!AnyUnused)
			{
			// clear the used flag for all weapons then pick a new index at random
			for(i=0; i < game.Num_Weapons; i++)
				game.HmWeaponsAvailList[i].nAlreadyUsed = false;

			do
				{
				NewWeapIdx = rand() % (game.Num_Weapons - 1);
				} while(game.HmWeaponsAvailList[NewWeapIdx].nWeaponNumber == game.Current_Weapon);
			}
		else
			{            
			// pick any weapon at random
			NewWeapIdx = rand() % (game.Num_Weapons - 1);

			// scan until weapon is unused (we know there is at least one)
			while(game.HmWeaponsAvailList[NewWeapIdx].nAlreadyUsed == true)
				{
				NewWeapIdx++;
				if( NewWeapIdx > (game.Num_Weapons-1) )
					NewWeapIdx = 0;
				}
			}

		game.HmWeaponsAvailList[NewWeapIdx].nAlreadyUsed = true;
		}
	else	// otherwise just give us whats available next.
		{
		game.Weapon_Index++;

		if (game.Weapon_Index > (game.Num_Weapons-1) )
			game.Weapon_Index = 0;

		NewWeapIdx = game.Weapon_Index;
		}

	game.Current_Weapon = game.HmWeaponsAvailList[NewWeapIdx].nWeaponNumber;
	}


/////////////////////////////////////////////////////////////////////////////
// hm_Initialise
//
//	This will setup all of the weapons index's so we can do without the
//	constant use of FindItem, it also sets the ammo ones too.
// 

void hm_Initialise( void )
	{
    int nWeap, i;
	int	nRndWeap=0;	// This must be set to 0 as its used for setting index 0 if no weapon is randomized

	// Load any extra text for the message of the day
//	Hm_LoadMOTD();

	// load the ini file with the required settings
	LoadHitmenWorldIni();

	// Check to see if the values we have are correct.
	VerifyIniFileValues();

    // Set the random number seed.
    srand( (unsigned)time( NULL ) );

    for(nWeap=1; nWeap<=MAXHMWEAPONS; nWeap++)
        {
        Hitmenlist[nWeap].nHmIndexWeapon = ITEM_INDEX(FindItem(Hitmenlist[nWeap].szName));
		Hitmenlist[nWeap].nHmIndexAmmo   = ITEM_INDEX(FindItem(Hitmenlist[nWeap].szAmmo));
        }

	// This will set the available weapons and how many
	hm_ProcessWeaponsList();

	// Clear the list of used weapons for getting the next available one
	for ( i=0; i < MAXHMWEAPONS; i++ )
		game.HmWeaponsAvailList[i].nAlreadyUsed = false;

	// If we are using random weapons then set the starting weapon random as well.
	if (HmRandomWeapon)
		if (game.Num_Weapons > 1)
			{
			nRndWeap = rand() % (game.Num_Weapons - 1);
			nWeap = game.HmWeaponsAvailList[ nRndWeap ].nWeaponNumber;
			}
		else
			nWeap = game.HmWeaponsAvailList[0].nWeaponNumber;
	else
		nWeap = game.HmWeaponsAvailList[0].nWeaponNumber;

	game.HmWeaponsAvailList[nRndWeap].nAlreadyUsed = true;
	game.Current_Weapon = nWeap;
	game.Last_Weapon = nWeap;
	game.Weapon_Index = 0;	// only used for sequential weapon access.

	game.Weapon_Timer_Reset = HmWeaponTime;
	game.Weapon_Timer = level.time + game.Weapon_Timer_Reset;

	}

/////////////////////////////////////////////////////////////////////////////
// hm_ProcessWeaponsList
//
// Sets up the list of available weapons.

void hm_ProcessWeaponsList( void )
	{
	int		WeaponCount=0, idx=0;

	if (HmWeaponsAvail & hm_PISTOL)
		{
		WeaponCount++;
		game.HmWeaponsAvailList[idx++].nWeaponNumber = 1;
		}

	if (HmWeaponsAvail & hm_SHOTGUN)
		{
		WeaponCount++;
		game.HmWeaponsAvailList[idx++].nWeaponNumber = 2;
		}

	if (HmWeaponsAvail & hm_TOMMYGUN)
		{
		WeaponCount++;
		game.HmWeaponsAvailList[idx++].nWeaponNumber = 3;
		}

	if (HmWeaponsAvail & hm_BARMACHINEGUN)
		{
		WeaponCount++;
		game.HmWeaponsAvailList[idx++].nWeaponNumber = 4;
		}

	if (HmWeaponsAvail & hm_GRENADELAUNCHER)
		{
		WeaponCount++;
		game.HmWeaponsAvailList[idx++].nWeaponNumber = 5;
		}

	if (HmWeaponsAvail & hm_ROCKETLAUNCHER)
		{
		WeaponCount++;
		game.HmWeaponsAvailList[idx++].nWeaponNumber = 6;
		}

	if (HmWeaponsAvail & hm_FLAMEGUN)
		{
		WeaponCount++;
		game.HmWeaponsAvailList[idx++].nWeaponNumber = 7;
		}

	game.Num_Weapons = WeaponCount;

	}

/////////////////////////////////////////////////////////////////////////////
// hm_Setcurrentweapon:
//
// Used to set the current weapon and ammo amount for new clients.

void Hm_Setcurrentweapon(gclient_t* cl, qboolean bResetAmmo)
	{
    int nCurWeaponIndex;
	int nAmmoIndex;
	int nAmmoInitial;
	gitem_t		*item, *ammo;

	if(!cl)
		return;

	nAmmoIndex       = Hitmenlist[game.Current_Weapon].nHmIndexAmmo;
    nCurWeaponIndex	 = Hitmenlist[game.Current_Weapon].nHmIndexWeapon;

//	if(bResetAmmo && (deathmatch->value || !level.intermissiontime))
//		{
        // not in intermission and/or in deathmatch allocate default ammo
		nAmmoInitial = Hitmenlist[game.Current_Weapon].nAmmoInitial;

		// Set the initial ammo for this weapon
		Hm_set_ammo(cl, nAmmoInitial, game.Current_Weapon, true);

//		}

	// allocate new weapon (in case not already done)
	cl->pers.inventory[nCurWeaponIndex] = 1;
	cl->newweapon                       = &itemlist[nCurWeaponIndex];
	cl->pers.weapon                     = &itemlist[nCurWeaponIndex];
    cl->pers.selected_item              = nCurWeaponIndex;
	cl->ammo_index						= nAmmoIndex;

	// Load the weapon with the correct ammo.
	item = FindItem(Hitmenlist[game.Current_Weapon].szName);
	ammo = FindItem (item->ammo);
	AutoLoadWeapon( cl, item, ammo );

	}

//////////////////////////////////////////////////////////////////////////
//
// Set the weapon Timer for 1 second and clear the second counter.
//

void Hm_Set_Timers(gclient_t* client)
	{
    if(!client)
        return;

	client->Hm_sectimer		= level.time + HM_ONESECOND;
		client->Hm_ammotics		= 0;
	client->Hm_timescaletimer = level.time + (HM_ONESECOND * 15);

	}

/////////////////////////////////////////////////////////////////////////////
//
//	check to see if we need to add some health or ammo.

void Hm_Check_Timers(edict_t* ent)
	{
	gclient_t* client;

  	if (!ent->inuse)
    	return;

    // don't do anything after client dies
	if (ent->health < 1)
        return;

	//FREDZ fix
	if (ent->client->pers.spectator == SPECTATING && !ent->client->pers.team)
		return;
	
	if ((level.modeset == FINALCOUNT) || (level.modeset == ENDMATCHVOTING)) //FREDZ fix
		return;

	client = ent->client;
	if (!client)
		return;

	// nothing to do if client is observing
//	if(ent->svflags & SVF_NOCLIENT)
//		return;

	if (client->Hm_sectimer < level.time)
		{
	    // increment health unless HmKillForHealth is true (means you have to kill clients to get health)
		if(!HmKillForHealth)
			hm_incrementhealth(ent, client);

	    // increment ammo unless infinite ammo is enabled
		if ( !((int)dmflags->value & DF_INFINITE_AMMO) )
	   		hm_incrementammo(client);

		// reset timer
		client->Hm_sectimer = level.time + HM_ONESECOND;
		}
	}

/////////////////////////////////////////////////////////////////////////////
// Hm_incrementammo:
//
// Each client maitains its own ammo timer?

void hm_incrementammo(gclient_t* client)
	{
	int nAmmoIncrease, nAmmoIndex;

    client->Hm_ammotics++;

    if (client->Hm_ammotics >= Hitmenlist[game.Current_Weapon].nAmmoSecs) 
        {
        client->Hm_ammotics = 0;

		nAmmoIncrease   = Hitmenlist[game.Current_Weapon].nAmmoIncrement;
       	nAmmoIndex      = Hitmenlist[game.Current_Weapon].nHmIndexAmmo;

       	if(nAmmoIncrease <= 0)
	    	{
//	   	    gi.dprintf ("NIQ: invalid ammo increase amount!\n");
        	return;							
		    }

       	if(nAmmoIndex <= 0)
	    	{
//	   	    gi.dprintf ("NIQ: invalid ammo index!\n");
   	    	return;							
		    }

		// goose up ammo (niq_add_ammo enforces limits)
		Hm_add_ammo(client, nAmmoIncrease, game.Current_Weapon);
        }
	}


/////////////////////////////////////////////////////////////////////////////
// hm_incrementhealth:
//
// Each client maintains his own health timer?

void hm_incrementhealth(edict_t *ent, gclient_t* client)
	{
	qboolean	noise = false;
	qboolean	bDrowning;
	qboolean	bInLava;
	qboolean	bInSlime;
	qboolean	bFighting;

    // health can't increase while drowning etc.
	bDrowning = (ent->waterlevel >= 3 && ent->air_finished < level.time);
	bInLava   = (ent->watertype & CONTENTS_LAVA);
	bInSlime  = (ent->watertype & CONTENTS_SLIME);

	// Can't add health whilst we are in the shit - so to speak.
	if(bDrowning || bInLava || bInSlime)
		return;

	if (ent->health < 100)
        {
		noise = HmHealthSound;

		// 28/03/98 niq: client health can't improve while fighting (firing weapon) in DM???
		bFighting = false;

		// test if human player is actively fighting -- defined as weapon is firing or client trying to fire weapon
		if(client->weaponstate == WEAPON_FIRING || ((client->latched_buttons|client->buttons) & BUTTON_ATTACK))
			bFighting = true;

		if(!bFighting)
   			ent->health += 5;
		else
			noise = false;

		if (ent->health > 100)
			ent->health = 100;
		}

    // do health increment sound?
	if (noise)
		gi.sound (ent, CHAN_AUTO, gi.soundindex ("world/pickups/health.wav"), 1, ATTN_STATIC, 0);			 
	}

/////////////////////////////////////////////////////////////////////////////
// hm_clientkill:
//
//	Once you've killed someone increase your health.
//

void hm_KilledCheckHealthIncrease(edict_t* attacker)
{
	int			nOrigHealth;
	gclient_t	*client;

    // if we are autoincrementing nothing to do
    if(!HmKillForHealth)
        return;
        
    // don't increment health after client dies!
  	if (!attacker->inuse)
    	return;

	client = attacker->client;
	if (!client)
		return;

    // is he dead?
	if (attacker->health < 1)
        return;

    nOrigHealth = attacker->health;

    attacker->health += 25; //niq_hlthinc->value;

    // make sure we didn't exceed the maximum allowed health
    if(attacker->health > 100 /*niq_hlthmax->value*/)
        attacker->health = 100; //niq_hlthmax->value;

    // do health increment sound?
    if( HmHealthSound && (attacker->health > nOrigHealth) )
		gi.sound (attacker, CHAN_AUTO, gi.soundindex ("world/pickups/health.wav"), 1, ATTN_STATIC, 0);			 
	}

/***********************************************************************
/*
/*	Function:	Displays text on screen upon entry into game
/*
/*	Parameters:	edict_t = player entity structure
/*
/**********************************************************************/
/*void Hm_LoadMOTD( void )
	{

	FILE	*motd_file;
	char	line[80];
	int		i;

	// Open the motd file
	if (motd_file = fopen("teamhitmen/motd.txt", "r"))
		{
		i = 0;

		// Read the lines now
		while ( fgets(line, 80, motd_file) )
			{
			// Once we've read a line copy it to the MOTD array.
			strcpy(MOTD[i].textline, line);
			i++;

			// We don't want more than 3 lines so lets piss off.
			if (i>3)
				break;
			}

		// be good now ! ... close the file
		fclose(motd_file);
		}
	}
*/
/***********************************************************************
/*
/*	Function:	Loads all the game settings.
/*
/*	Parameters:	None
/*
/**********************************************************************/
void LoadHitmenWorldIni( void )
	{	
	FILE	*f;
	cvar_t	*game_dir;
	int		IniOption = 0, Processed = 0;
	char	Buffer[256], filename[256];
	char	*VariableName = NULL, *VariableValue = NULL;
	static	qboolean	AlreadyRead = false;


//	if (AlreadyRead)
//		return;

	game_dir = gi.cvar ("game", "", 0);

    sprintf(filename, ".\\%s\\%s", game_dir->string, INI_FILE);

	// open the *.ini file

	if ((f = fopen (filename, "r")) == NULL)
		{
		gi.dprintf("Unable to read %s. Using defaults.\n", INI_FILE);
		return;
		}

	gi.dprintf("\nProcessing Hitmen %s.. \n", INI_FILE);

	// read 256 characters or until we get to the eof or a return for a newline.

	while (fgets(Buffer, sizeof(Buffer), f) != NULL)
		{

		
		// Ignore this line if it starts with a #, newline, space or [ bracket.

		if (Buffer[0] != '\t' && Buffer[0] != ' ' && Buffer[0] != '\n' && Buffer[0] != '#' && Buffer[0] != '[')
			{

			// Get the variable name, skipping spaces, tabs, and newlines.

			VariableName	= strtok(Buffer, " \t\n");
			IniOption	= 0;

			// If we haven't processed the maximum number of options then keep going
			while (IniOption < MAX_OPTIONS)
				{

				// Find this option in the array of options, if we don't find it tough

				if (!strcmp(VariableName, option[IniOption].ident))
					{

					// Using NULL will continue the search for the value from where the previous
					// strtok for the variable name left off.
					VariableValue = strtok(NULL, " \t\n#");

					// If the variable name is stdlog then we want to set the flag to turn
					// logging on
					if (!strcmp(VariableName, "stdlog"))
						gi.cvar_set("stdlogfile", VariableValue);
					else
					// This will set the valu in the array using string value to integer conversion
					*option[IniOption].variable = atoi(VariableValue);

					Processed++;
					break;
					}

				IniOption++;
				}
			}
		}

	gi.dprintf("%d Hitmen Options processed\n", Processed);
	fclose (f);
	AlreadyRead = true;	
	}

/***********************************************************************
/*
/*	Function:	Ensures that no knobs try to frig the values.
/*
/*	Parameters:	None
/*
/**********************************************************************/
void VerifyIniFileValues( void )
	{	
	int	Loop;
//	char buffer[20];
//	char *buffer;

	for ( Loop=0; Loop<MAX_OPTIONS; Loop++ )
		{

		// If the value which has been set isn't in the normal range then
		// set it to a default value.

		if ((*option[Loop].variable < option[Loop].MinVariable) ||
			(*option[Loop].variable > option[Loop].MaxVariable))
			{
			*option[Loop].variable = option[Loop].DefaultVariable;
			}
		}
	
//	itoa(Hmfraglimit, buffer, 10);
//	buffer = IntToChar(Hmfraglimit);
//	gi.cvar_set ("fraglimit",buffer);

//	itoa(Hmtimelimit, buffer, 10);
//	buffer = IntToChar(Hmtimelimit);
//	gi.cvar_set ("timelimit",buffer);
	}

/***********************************************************************
/*	Function:	This is a special bit of code for [BC]Truz so he can
/*				change the settings every level. 
/*
/**********************************************************************/
void LoadLevelSettings( char *LevelName )
	{	
	FILE	*f;
	cvar_t	*game_dir;
	int		IniOption = 0, Processed = 0;
	char	Buffer[256], Filename[256], FullPathname[256];
	char	*VariableName = NULL, *VariableValue = NULL;

	strcpy( Filename, LevelName );
	strcat( Filename, ".ini" );

//	game_dir = gi.cvar ("game", "", 0);
	
	game_dir = gi.cvar("game", "", 0);

	if (game_dir->string[0]==0)
		strcpy(Filename, "main");
	else
		strcpy(Filename, game_dir->string);

    sprintf(FullPathname, ".\\%s\\%s", game_dir->string, Filename);
	//sprintf (FullPathname, sizeof(FullPathname), "%s"DIR_SLASH"hitmen.ini",Filename);

	// open the *.ini file

	if ((f = fopen (FullPathname, "r")) == NULL)
		{
		gi.dprintf("Unable to read %s. Using Hitmen.ini.\n", LevelName);
		LoadHitmenWorldIni();
		VerifyLevelIniValues();
		return;
		}

	gi.dprintf("\nProcessing %s's settings\n", LevelName);

	// read 256 characters or until we get to the eof or a return for a newline.

	while (fgets(Buffer, sizeof(Buffer), f) != NULL)
		{
		// Ignore this line if it starts with a #, newline, space or [ bracket.

		if (Buffer[0] != '\t' && Buffer[0] != ' ' && Buffer[0] != '\n' && Buffer[0] != '#' && Buffer[0] != '[')
			{

			// Get the variable name, skipping spaces, tabs, and newlines.

			VariableName	= strtok(Buffer, " \t\n");
			IniOption	= 0;

			// If we haven't processed the maximum number of options then keep going
			while (IniOption < MAX_OPTIONS)
				{

				// Find this option in the array of options, if we don't find it tough

				if (!strcmp(VariableName, option[IniOption].ident))
					{

					// Using NULL will continue the search for the value from where the previous
					// strtok for the variable name left off.
					VariableValue = strtok(NULL, " \t\n#");

					// If the variable name is stdlog then we want to set the flag to turn
					// logging on
					if (!strcmp(VariableName, "stdlog"))
						gi.cvar_set("stdlogfile", VariableValue);
					else
					// This will set the value in the array using string value to integer conversion
					*option[IniOption].variable = atoi(VariableValue);

					Processed++;
					break;
					}

				IniOption++;
				}
			}
		}

	gi.dprintf("%d Level settings processed\n", Processed);
	fclose (f);

	// Now verify that the settings are okay and reset all the Hitmen stuff such as weapon
	// lists and timers.
	VerifyLevelIniValues();

	}

/***********************************************************************
/*
/*	Function:	Loads all the game settings and then resets the game
/*				settings so that the correct weapon list is setup.
/*
/*	Parameters:	None
/*
/**********************************************************************/
void VerifyLevelIniValues( void )
	{	
	int	Loop;
    int nWeap, i;
	int	nRndWeap=0;	// This must be set to 0 as its used for setting index 0 if no weapon is randomized
//	char buffer[20];
//	char *buffer;

	for ( Loop=0; Loop<MAX_OPTIONS; Loop++ )
		{

		// If the value which has been set isn't in the normal range then
		// set it to a default value.

		if ((*option[Loop].variable < option[Loop].MinVariable) ||
			(*option[Loop].variable > option[Loop].MaxVariable))
			{
			*option[Loop].variable = option[Loop].DefaultVariable;
			}
		}

	// These have been moved here for changing on a level to level basis.
//	itoa(Hmfraglimit, buffer, 10);
//	buffer = IntToChar(Hmfraglimit);
//	gi.cvar_set ("fraglimit",buffer);

//	itoa(Hmtimelimit, buffer, 10);
//	buffer = IntToChar(Hmtimelimit);
//	gi.cvar_set ("timelimit",buffer);

    // Set the random number seed.
    srand( (unsigned)time( NULL ) );

    for(nWeap=1; nWeap<=MAXHMWEAPONS; nWeap++)
        {
        Hitmenlist[nWeap].nHmIndexWeapon = ITEM_INDEX(FindItem(Hitmenlist[nWeap].szName));
		Hitmenlist[nWeap].nHmIndexAmmo   = ITEM_INDEX(FindItem(Hitmenlist[nWeap].szAmmo));
        }

	// This will set the available weapons and how many
	hm_ProcessWeaponsList();

	// Clear the list of used weapons for getting the next available one
	for ( i=0; i < MAXHMWEAPONS; i++ )
		game.HmWeaponsAvailList[i].nAlreadyUsed = false;

	// If we are using random weapons then set the starting weapon random as well.
	if (HmRandomWeapon)
		if (game.Num_Weapons > 1)
			{
			nRndWeap = rand() % (game.Num_Weapons - 1);
			nWeap = game.HmWeaponsAvailList[ nRndWeap ].nWeaponNumber;
			}
		else
			nWeap = game.HmWeaponsAvailList[0].nWeaponNumber;
	else
		nWeap = game.HmWeaponsAvailList[0].nWeaponNumber;

	game.HmWeaponsAvailList[nRndWeap].nAlreadyUsed = true;
	game.Current_Weapon = nWeap;
	game.Last_Weapon = nWeap;
	game.Weapon_Index = 0;	// only used for sequential weapon access.

	game.Weapon_Timer_Reset = HmWeaponTime;
	game.Weapon_Timer = level.time + game.Weapon_Timer_Reset;


	}


